' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

Partial Class Members
  Inherits System.Web.UI.Page
  Private pageIndex As Integer = 0
  Private numPages As Integer = 0

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    pnlRoles.Visible = False
    pnlApplications.Visible = False

    If Not Page.IsPostBack Then
      LoadData()
    End If

  End Sub

  Private Sub LoadData()
    Dim totalNumRecords As Integer = 0
    If ViewState("PageIndex") IsNot Nothing Then
      pageIndex = Convert.ToInt32(ViewState("PageIndex"))
    End If
    ViewState("PageIndex") = pageIndex

    grdMembers.DataSource = Membership.GetAllUsers(pageIndex, grdMembers.PageSize, totalNumRecords)
    grdMembers.DataBind()

    ' Pobierz liczb stron. Przy dzieleniu liczb cakowitych warto decymalna jest zaokrglana w d,
    ' wic nastpna instrukcja pobiera liczb penych stron
    numPages = Convert.ToInt32(totalNumRecords / grdMembers.PageSize)

    ' Teraz musimy sprawdzi czy zostao co na ostatni stron
    If numPages * grdMembers.PageSize < totalNumRecords Then
      numPages += 1
    End If
    lnkPreviousPage.Visible = (pageIndex > 0)
    lnkNextPage.Visible = (pageIndex < numPages - 1)
  End Sub


  Protected Sub btnSaveRoles_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSaveRoles.Click
    Dim memberId As Guid = New Guid(ViewState("MemberId").ToString())
    Dim theMember As MembershipUser = Membership.GetUser(memberId)
    For Each anItem As ListItem In lstRoles.Items
      If anItem.Selected = True Then
        If Not Roles.IsUserInRole(theMember.UserName, anItem.Value) Then
          Roles.AddUserToRole(theMember.UserName, anItem.Value)
        End If
      Else
        If Roles.IsUserInRole(theMember.UserName, anItem.Value) Then
          Roles.RemoveUserFromRole(theMember.UserName, anItem.Value)
        End If
      End If
    Next
    pnlRoles.Visible = False
  End Sub

  Protected Sub btnSaveApplications_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSaveApplications.Click
    Dim memberId As Guid = New Guid(ViewState("MemberId").ToString())
    For Each anItem As ListItem In lstApplications.Items
      If anItem.Selected = True Then
        MemberManager.AssignMemberToApplication(memberId, Convert.ToInt32(anItem.Value))
      Else
        MemberManager.UnAssignMemberFromApplication(memberId, Convert.ToInt32(anItem.Value))
      End If
    Next
    pnlApplications.Visible = False
  End Sub

  Protected Sub lnkPreviousPage_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkPreviousPage.Click
    If ViewState("PageIndex") IsNot Nothing Then
      Dim pageIndex As Integer = 0
      pageIndex = CType(ViewState("PageIndex"), Integer) - 1
      If pageIndex < 0 Then
        pageIndex = 0
      End If
      ViewState("PageIndex") = pageIndex
      LoadData()
    End If
  End Sub

  Protected Sub lnkNextPage_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkNextPage.Click
    If ViewState("PageIndex") IsNot Nothing Then
      ViewState("PageIndex") = CType(ViewState("PageIndex"), Integer) + 1
      LoadData()
    End If
  End Sub

  Protected Sub grdMembers_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles grdMembers.RowDataBound
    Select Case e.Row.RowType
      Case DataControlRowType.DataRow
        Dim myDeleteButton As LinkButton = CType(e.Row.Controls(5).Controls(0), LinkButton)
        myDeleteButton.Attributes.Add("onclick", "return confirm('Czy na pewno usun tego czonka zespou?');")
        myDeleteButton.CommandArgument = e.Row.RowIndex.ToString
        ' break 
    End Select
  End Sub

  Protected Sub grdMembers_RowCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles grdMembers.RowCommand
    Select Case e.CommandName.ToUpper
      Case "DELETEMEMBER"
        Dim rowIndex As Integer = Convert.ToInt32(e.CommandArgument)
        Dim memberId As Guid = New Guid(grdMembers.DataKeys(rowIndex).Value.ToString)
        Dim theMember As MembershipUser = Membership.GetUser(memberId)
        theMember.IsApproved = False
        Membership.UpdateUser(theMember)
        LoadData()

      Case "ROLES"
        Dim rowIndex As Integer = Convert.ToInt32(e.CommandArgument)
        Dim memberId As Guid = New Guid(grdMembers.DataKeys(rowIndex).Value.ToString)
        Dim theMember As MembershipUser = Membership.GetUser(memberId)

        legendRoles.InnerText = "Przypisz role uytkownikowi " + theMember.UserName
        lstRoles.DataSource = Roles.GetAllRoles()
        lstRoles.DataBind()
        For Each myItem As ListItem In lstRoles.Items
          If (Roles.IsUserInRole(theMember.UserName, myItem.Value)) Then
            myItem.Selected = True
          End If
        Next
        pnlRoles.Visible = True
        ' Zachowaj identyfikator wybranego czonka zespou w ViewState, ebysmy mogli pobra go znowu
        ' w metodzie btnSaveRoles_Click
        ViewState("MemberId") = memberId

      Case "APPLICATIONS"
        Dim rowIndex As Integer = Convert.ToInt32(e.CommandArgument)
        Dim memberId As Guid = New Guid(grdMembers.DataKeys(rowIndex).Value.ToString)
        Dim theMember As MembershipUser = Membership.GetUser(memberId)

        legendApplications.InnerText = "Przydziel aplikacje uytkownikowi: " + theMember.UserName
        lstApplications.DataSource = ListManager.GetApplicationItems()
        lstApplications.DataTextField = "Description"
        lstApplications.DataValueField = "Id"
        lstApplications.DataBind()
        For Each myItem As ListItem In lstApplications.Items
          For Each application As DataRow In ListManager.GetApplicationItems(memberId).Tables(0).Rows
            If Convert.ToInt32(application("id")) = Convert.ToInt32(myItem.Value) Then
              myItem.Selected = True
            End If
          Next
        Next
        pnlApplications.Visible = True
        ' Zachowaj identyfikator wybranego czonka zespou w ViewState, ebysmy mogli pobra go znowu
        ' w metodzie btnSaveApplications_Click
        ViewState("MemberId") = memberId
    End Select
  End Sub

End Class
